## Валидация данных

При валидации данных валидатор последовательно применяет к значению поля заданные правила, при возникновении ошибки в массив данных об ошибках добавляется запись и дальнейшая обработка формы прекращается.

Валидация считается пройденной, если в массиве данных об ошибках отсутствуют записи. 

### Правила валидации
Список правил задается в виде массива. Ключом является имя поля, а значением - массив правил валидации. Правило валидации является методом класса-валидатора. В массиве правил ключом является имя правила (название метода валидации), значением может быть либо строка с сообщением об ошибке валидации правила, или же массив с описанием. В этом массиве в ключе params задаются необходимые для валидации значения, а в ключе message задается строка с сообщением об ошибке.

Можно также использовать отрицание правил, если добавить перед именем правила восклицательный знак: "!numeric" - поле пройдет валидацию, если его значение не является числом.

Если нужно реализовать проверку только заполненных полей, то перед именем поля в списке правил нужно добавить восклицательный знак. В этом случае если значение поля пустое, правила будут проигнорированы.

```
{
    "имя поля 1": {
        "правило 1" : "сообщение об ошибке",
        "правило 2" : "сообщение об ошибке"
    },
    "имя поля 2": {
        "правило 1" : "сообщение об ошибке",
        "правило 2" : {
            "params" : значение,
            "message" : "сообщение об ошибке"
        }
    },
    "!имя поля 3":{
        "правило 1" : "сообщение об ошибке"
    }
}
```
Стандартным классом валидации (\FormLister\Validator) предусмотрены правила:

- required: поле заполнено;
- date: значение поля является датой в заданном формате;
- min: значение поля больше заданного или равно ему;
- max: значение поля меньше заданного или равно ему;
- greater: значение поля строго меньше заданного;
- less: значение поля строго больше заданного;
- between: значение поля входит в диапазон;
- equals: значение поля равно заданному;
- in: значение поля входит в заданный массив значений;
- alpha: значение поля содержит только буквы;
- numeric: значение поля содержит только цифры;
- alphaNumeric: значение поля содержит только буквы и цифры;
- slug: значение поля является частью url;
- decimal: значение поля является десятичным числом;
- phone: значение поля является номером телефона;
- matches: значение поля удовлетворяет регулярному выражению;
- url: значение поля является ссылкой;
- email: значение поля является email-адресом;
- length: длина значения поля равна заданному;
- minLength: длина значения поля больше заданного или равна ему;
- maxLength: длина значения поля меньше заданного или равна ему;
- lengthBetween: длина значения поля входит в диапазон;
- minCount: размер массива больше заданного;
- maxCount: размер массива меньше заданного;
- countBetween: размер массива входит в диапазон.

Если требуется задать два значения для правила, то их следует задавать как массив:
```
&rules=`{
    "field" : {
        "lengthBetween" : {
            "params" : [10,20],
            "message" : "Длина должна быть от 10 до 20"
        }
    }
}`
```

Для правила in (и других правил, использующих массив) массив значений следует задавать следующим образом:
```
&rules=`{
    "field" : {
        "in" : {
            "params" : [ [10,20,30] ],
            "message" : "Значение поля field должно быть равно 10, 20 или 30"
        }
    }
}`
```

Это нужно, чтобы массив был передан в функцию одним аргументом.

Предусмотрена также возможность использовать для валидации функции или статические методы загруженного класса:
```
&rules=`{
    "myfield":{
        "required":"Required field",
        "custom":{
            "function":"\\Namespace\\Classname::myCustomRule",
            "params":[10,20,30],
            "message":"Custom check failed"
        }
    }
}`
```

Метод должен принимать первым аргументом экземпляр контроллера из которого вызывается правило, вторым аргументом - значение проверяемого поля, далее - параметры передаваемые в ключе описания params:
```
public static function myCustomRule($fl,$value,$a,$b,$c) {
    $result = $fl->getField('field1') == $a && $fl->getField('field2') == $b && $value == $c;
    return $result;
}
```
В примере правило будет пройдено, если значение поля field1 = 10, значение поля field2 = 20, а значение поля, к которму применяется правило, = 30.

Метод должен вернуть true, false или текст сообщения об ошибке (в этом случае можно не указывать message в списке правил).

В примере используется название правила "сustom", но можно использовать любое название правила, которого нет в классе валидации. Таким образом можно использовать несколько правил данного типа.

### Результаты валидации
Данные об ошибках хранятся в виде массива и могут быть получены вызовом метода getFormData('errors'):
```
{
    "имя поля 1": {
        "имя нарушенного правила" : "сообщение об ошибке"
    },
    "имя поля 2": {
        "имя нарушенного правила" : "сообщение об ошибке"
    }
}
```
Для добавления данных в этот массив используется метод addError(имя поля, имя правила, сообщение об ошибке). Таким образом, можно влиять на итоговый результат валидации, вручную добавляя записи в этот массив. Можно также объявить валидацию непройденной по умолчанию, вызвав метод setValid(false). 

В шаблонах результаты валидации для каждого поля выводятся с помощью плейсхолдера [+имя поля.error+]. Общий результат может быть выведен в плейсхолдер [+form.messages+], который задается шаблоном messagesTpl. В свою очередь, в этом шаблоне можно использовать плейсхолдеры: 

- [+required+] - сообщения о незаполенных полях;
- [+errors+] - сообщения о неверно заполненных полях.

Получить сообщения об ошибках для определенного поля можно с помощью метода getErrorMessage(имя поля).
